% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_number_survey2.R
\name{show_sig_number_survey2}
\alias{show_sig_number_survey2}
\title{Show Comprehensive Signature Number Survey}
\usage{
show_sig_number_survey2(
  x,
  y = NULL,
  what = c("all", "cophenetic", "rss", "residuals", "dispersion", "evar", "sparseness",
    "sparseness.basis", "sparseness.coef", "silhouette", "silhouette.coef",
    "silhouette.basis", "silhouette.consensus"),
  na.rm = FALSE,
  xlab = "Number of signature",
  ylab = "",
  main = "Signature number survey using NMF package"
)
}
\arguments{
\item{x}{a \code{data.frame} or \code{NMF.rank} object obtained from \code{\link[=sig_estimate]{sig_estimate()}}.}

\item{y}{for random simulation,
a \code{data.frame} or \code{NMF.rank} object obtained from \code{\link[=sig_estimate]{sig_estimate()}}.}

\item{what}{a character vector whose elements partially match one of the following item,
which correspond to the measures computed by \code{summary()} on each – multi-run – NMF result:
'all', 'cophenetic', 'rss', 'residuals', 'dispersion', 'evar', 'silhouette'
(and more specific \verb{*.coef}, \verb{*.basis}, \verb{*.consensus}), 'sparseness'
(and more specific \verb{*.coef}, \verb{*.basis}).
It specifies which measure must be plotted (what='all' plots all the measures).}

\item{na.rm}{single logical that specifies if the rank
  for which the measures are NA values should be removed
  from the graph or not (default to \code{FALSE}).  This is
  useful when plotting results which include NAs due to
  error during the estimation process. See argument
  \code{stop} for \code{nmfEstimateRank}.}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{main}{main title}
}
\value{
a \code{ggplot} object
}
\description{
This function is modified from \strong{NMF} package to
better help users to explore survey of signature number.
}
\examples{
\donttest{
load(system.file("extdata", "toy_copynumber_tally_M.RData",
  package = "sigminer", mustWork = TRUE
))
library(NMF)
cn_estimate <- sig_estimate(cn_tally_M$nmf_matrix,
  cores = 1, nrun = 5,
  verbose = TRUE,
  keep_nmfObj = TRUE
)

# Show from data.frame obtained by sig_estimate()
show_sig_number_survey2(cn_estimate$survey)
show_sig_number_survey2(cn_estimate$survey, y = cn_estimate$survey.random)

# Show directly from NMF.rank object
show_sig_number_survey2(cn_estimate$nmfEstimate)
show_sig_number_survey2(cn_estimate$nmfEstimate, y = cn_estimate$nmfEstimate.random)
}
}
