% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_group_distribution.R
\name{show_group_distribution}
\alias{show_group_distribution}
\title{Show Groupped Variable Distribution}
\usage{
show_group_distribution(
  data,
  gvar,
  dvar,
  fun = stats::median,
  order_by_fun = FALSE,
  alpha = 0.8,
  g_label = "label",
  g_angle = 0,
  g_position = "top",
  point_size = 1L,
  segment_size = 1L,
  segment_color = "red",
  xlab = NULL,
  ylab = NULL,
  nrow = 1L,
  background_color = c("#DCDCDC", "#F5F5F5")
)
}
\arguments{
\item{data}{a \code{data.frame}.}

\item{gvar}{a group variable name/index.}

\item{dvar}{a distribution variable name/index.}

\item{fun}{a function to summarize, default is \link[stats:median]{stats::median}, can also be \link{mean}.}

\item{order_by_fun}{if \code{TRUE}, reorder the groups by summary measure computed
by argument \code{fun}.}

\item{alpha}{alpha for points, range from 0 to 1.}

\item{g_label}{a string 'label' (default) for labeling with sample size,
or 'norm' to show just group name, or a named vector to set facet labels.}

\item{g_angle}{angle for facet labels, default is \code{0}.}

\item{g_position}{position for facet labels, default is 'top', can also
be 'bottom'.}

\item{point_size}{size of point.}

\item{segment_size}{size of segment.}

\item{segment_color}{color of segment.}

\item{xlab}{title for x axis.}

\item{ylab}{title for y axis.}

\item{nrow}{number of row.}

\item{background_color}{background color for plot panel.}
}
\value{
a \code{ggplot} object.
}
\description{
This is a general function, it can be used in any proper analysis.
}
\examples{
set.seed(1234)
data <- data.frame(
  yval = rnorm(120),
  gr = c(rep("A", 50), rep("B", 40), rep("C", 30))
)
p <- show_group_distribution(data,
  gvar = 2, dvar = 1,
  g_label = "norm",
  background_color = "grey"
)
p
p2 <- show_group_distribution(data,
  gvar = "gr", dvar = "yval",
  g_position = "bottom",
  order_by_fun = TRUE,
  alpha = 0.3
)
p2

# Set custom group names
p3 <- show_group_distribution(data,
                        gvar = 2, dvar = 1,
                        g_label = c("A"="X", "B"="Y", "C"="Z")
)
p3
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
