% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_series.R
\name{draw_sig_profile}
\alias{draw_sig_profile}
\title{Plot signature profile}
\usage{
draw_sig_profile(nmfObj, mode = c("copynumber", "mutation"),
  y_scale = c("relative", "absolute"), font_scale = 1)
}
\arguments{
\item{nmfObj}{a \code{NMF} result object which is an element return from \link{sig_extract}
or run results of \strong{NMF} package.}

\item{mode}{variation type to decompose, currently support "copynumber" or "mutation".}

\item{y_scale}{one of 'relative' or 'absolute', if choose 'relative',
signature columns will be scaled to sum as 1.}

\item{font_scale}{a number used to set font scale.}
}
\value{
a \code{ggplot} object
}
\description{
Currently support copy number signatures and mutation signatures.
}
\examples{
# Load copy number signature
load(system.file("extdata", "toy_copynumber_signature.RData",
  package = "sigminer", mustWork = TRUE
))
draw_sig_profile(res$nmfObj)
}
\seealso{
Other signature plot: \code{\link{draw_sig_activity}},
  \code{\link{draw_sig_corrplot}},
  \code{\link{draw_subtypes_comparison}}
}
\author{
Shixiang Wang
}
\concept{signature plot}
