% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doublesigmoidalFitFunctions.R
\name{doublesigmoidalFitFormula}
\alias{doublesigmoidalFitFormula}
\title{Double Sigmoidal Formula}
\usage{
doublesigmoidalFitFormula(x, finalAsymptoteIntensityRatio, maximum,
  slope1Param, midPoint1Param, slope2Param, midPointDistanceParam)
}
\arguments{
\item{x}{the "time" (time) column of the dataframe}

\item{finalAsymptoteIntensityRatio}{This is the ratio between asymptote intensity and maximum intensity of the fitted curve.}

\item{maximum}{the maximum intensity that the double sigmoidal function reach.}

\item{slope1Param}{the slope parameter of the sigmoidal function at the steppest point in the exponential phase of the viral production.}

\item{midPoint1Param}{the x axis value of the steppest point in the function.}

\item{slope2Param}{the slope parameter of the sigmoidal function at the steppest point in the lysis phase. i.e when the intensity is decreasing.}

\item{midPointDistanceParam}{the distance between the time of steppest increase and steppest decrease in the intensity data. In other words the distance between the x axis values of arguments of slope1Param and slope2Param.}
}
\value{
Returns the predicted intensities for the given time points with the double-sigmoidal fitted parameters for the double sigmoidal fit.
}
\description{
Calculates intensities using the double-sigmoidal model fit and the parameters (maximum, final asymptote intensity, slope1Param, midpoint1Param, slope2Param, and mid point distance).
}
\examples{
time <- seq(3, 24, 0.1)

#simulate intensity data and add noise
noise_parameter <- 0.2
intensity_noise <- stats::runif(n = length(time), min = 0, max = 1) * noise_parameter
intensity <- doublesigmoidalFitFormula(time,
                                      finalAsymptoteIntensityRatio = .3,
                                      maximum = 4,
                                      slope1Param = 1,
                                      midPoint1Param = 7,
                                      slope2Param = 1,
                                      midPointDistanceParam = 8)
intensity <- intensity + intensity_noise

dataInput <- data.frame(intensity = intensity, time = time)
normalizedInput <- normalizeData(dataInput)
parameterVector <- doublesigmoidalFitFunction(normalizedInput, tryCounter = 2)


#Check the results
if(parameterVector$isThisaFit){
 intensityTheoretical <-
       doublesigmoidalFitFormula(
               time,
               finalAsymptoteIntensityRatio = parameterVector$finalAsymptoteIntensityRatio_Estimate,
               maximum = parameterVector$maximum_Estimate,
               slope1Param = parameterVector$slope1Param_Estimate,
               midPoint1Param = parameterVector$midPoint1Param_Estimate,
               slope2Param = parameterVector$slope2Param_Estimate,
               midPointDistanceParam = parameterVector$midPointDistanceParam_Estimate)

 comparisonData <- cbind(dataInput, intensityTheoretical)

 require(ggplot2)
 ggplot(comparisonData) +
   geom_point(aes(x = time, y = intensity)) +
   geom_line(aes(x = time, y = intensityTheoretical)) +
   expand_limits(x = 0, y = 0)
   }

if(!parameterVector$isThisaFit){
  print(parameterVector)
  }


}
