% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal-functions.R
\name{optimal_functions}
\alias{optimal_functions}
\alias{optimal_FV}
\alias{optimal_MSS_MAC}
\title{Optimal profile functions}
\usage{
optimal_FV(
  distance,
  F0,
  V0,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  method = "max",
  ...
)

optimal_MSS_MAC(distance, MSS, MAC)
}
\arguments{
\item{distance}{Numeric vector}

\item{F0, V0}{Numeric vectors. FV profile parameters}

\item{bodymass}{Body mass in kg}

\item{inertia}{External inertia in kg (for example a weight vest, or a sled).
Not included in the air resistance calculation}

\item{resistance}{External horizontal resistance in Newtons (for example tether device or a sled friction resistance)}

\item{method}{Method to be utilized. Options are "peak" and "max" (default)}

\item{...}{Forwarded to \code{\link{get_air_resistance}} for the purpose of calculation of air resistance}

\item{MSS, MAC}{Numeric vectors. Model parameters}
}
\value{
\code{optimal_FV} returns s data frame with the following columns
    \describe{
        \item{F0}{Original F0}
        \item{V0}{Original F0}
        \item{bodymass}{Bodymass}
        \item{inertia}{Inertia}
        \item{resistance}{Resistance}
        \item{Pmax}{Maximal power estimated using F0 * V0 / 4}
        \item{Pmax_rel}{Relative maximal power}
        \item{slope}{FV profile slope}
        \item{distance}{Distance}
        \item{time}{Time to cover distance}
        \item{Ppeak}{Peak power estimated quantitatively}
        \item{Ppeak_rel}{Relative peak power}
        \item{Ppeak_dist}{Distance at which peak power is manifested}
        \item{Ppeak_time}{Time at which peak power is manifested}
        \item{F0_optim}{Optimal F0}
        \item{F0_coef}{Ratio between F0_optim an F0}
        \item{V0_optim}{Optimal V0}
        \item{V0_coef}{Ratio between V0_optim an V0}
        \item{Pmax_optim}{Optimal maximal power estimated F0_optim * V0_optim / 4}
        \item{Pmax_rel_optim}{Optimal relative maximal power}
        \item{slope_optim}{Optimal FV profile slope}
        \item{profile_imb}{Percent ratio between slope and optimal slope}
        \item{time_optim}{Time to cover distance when profile is optimal}
        \item{time_gain}{Difference in time to cover distance between time_optimal and time}
        \item{Ppeak_optim}{Optimal peak power estimated quantitatively}
        \item{Ppeak_rel_optim}{Optimal relative peak power}
        \item{Ppeak_dist_optim}{Distance at which optimal peak power is manifested}
        \item{Ppeak_time_optim}{Time at which optimal peak power is manifested}
   }

\code{optimal_MSS_MAC} returns a data frame with the following columns
    \describe{
        \item{MSS}{Original MSS}
        \item{MAC}{Original MAC}
        \item{Pmax_rel}{Relative maximal power estimated using MSS * MAC / 4}
        \item{slope}{Sprint profile slope}
        \item{distance}{Distance}
        \item{time}{Time to cover distance}
        \item{MSS_optim}{Optimal MSS}
        \item{MSS_coef}{Ratio between MSS_optim an MSS}
        \item{MAC_optim}{Optimal MAC}
        \item{MAC_coef}{Ratio between MAC_optim an MAC}
        \item{Pmax_rel_optim}{Optimal relative maximal power estimated using MSS_optim * MAC_optim / 4}
        \item{slope_optim}{Optimal sprint profile slope}
        \item{profile_imb}{Percent ratio between slope and optimal slope}
        \item{time_optim}{Time to cover distance when profile is optimal}
        \item{time_gain}{Difference in time to cover distance between time_optimal and time}
   }
}
\description{
Family of functions that serve a purpose of finding optimal sprint or force-velocity profile

\code{optimal_FV} finds "optimal" \code{F0} and \code{V0} where time at distance is
    minimized, while keeping the power the same

\code{optimal_MSS_MAC} finds "optimal" \code{MSS} and \code{MAS} where time at distance is
    minimized, while keeping the \code{Pmax} the same
}
\examples{
MSS <- 10
MAC <- 8
bodymass <- 75

fv <- make_FV_profile(MSS, MAC, bodymass)

dist <- seq(5, 40, by = 5)

opt_MSS_MAC_profile <- optimal_MSS_MAC(
  distance = dist,
  MSS,
  MAC
)[["profile_imb"]]

opt_FV_profile <- optimal_FV(
  distance = dist,
  fv$F0,
  fv$V0,
  fv$bodymass
)[["profile_imb"]]

opt_FV_profile_peak <- optimal_FV(
  distance = dist,
  fv$F0,
  fv$V0,
  fv$bodymass,
  method = "peak"
)[["profile_imb"]]

plot(x = dist, y = opt_MSS_MAC_profile, type = "l", ylab = "Profile imbalance")
lines(x = dist, y = opt_FV_profile, type = "l", col = "blue")
lines(x = dist, y = opt_FV_profile_peak, type = "l", col = "red")
abline(h = 100, col = "gray", lty = 2)
}
\references{
Samozino P, Peyrot N, Edouard P, Nagahara R, Jimenez‐Reyes P, Vanwanseele B, Morin J. 2022.
     Optimal mechanical force-velocity profile for sprint acceleration performance.
      Scandinavian Journal of Medicine & Science in Sports 32:559–575. DOI: 10.1111/sms.14097.
}
