% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_template.R
\name{create_template}
\alias{create_template}
\title{Create a skeleton application containing empty modules}
\usage{
create_template(
  path,
  name,
  common_objects,
  modules,
  author,
  include_map = TRUE,
  include_table = TRUE,
  include_code = TRUE,
  install = FALSE,
  logger = NULL
)
}
\arguments{
\item{path}{character. Path to where the app should be created}

\item{name}{character. Name of the app which will be used as the package name.
Must be only characters and numbers and not start with a number.}

\item{common_objects}{character vector. Names of objects which will be shared
between modules. The objects meta, logger and state are included by default
and if include_map is TRUE, the object poly is included to store polygons
drawn on the map.}

\item{modules}{dataframe. Containing one row for each module in the order
to be included and with the following column names:
\itemize{
\item \code{component} character. Single word descriptor for the component used to name files
\item \code{long_component} character. Full component name displayed to the user, formatted appropriately
\item \code{module} character. Single word descriptor for the module used to name files
\item \code{long_module} character. Full module name displayed to the user, formatted appropriately
\item \code{map} logical. Whether or not the module interacts with the map
\item \code{result} logical. Whether or not the module produces results
\item \code{rmd} logical. Whether or not the module is included in the markdown
\item \code{save} logical. Whether or not the input values of the module should be saved
\item \code{download} logical. Whether or not the module should include a downloadHandler
\item \code{async} logical. Whether or not the module will run asynchronously
}}

\item{author}{character. Name of the author(s)}

\item{include_map}{logical. Whether to include a leaflet map. Default \code{TRUE}}

\item{include_table}{logical. Whether to include a table tab. Default \code{TRUE}}

\item{include_code}{logical. Whether to include a tab for viewing module
code. Default \code{TRUE}}

\item{install}{logical. Whether to install the package. Default \code{FALSE}}

\item{logger}{Stores all notification messages to be displayed in the Log
Window. Insert the logger reactive list here for running in
shiny, otherwise leave the default \code{NULL}}
}
\value{
No return value, called for side effects
}
\description{
Creates a skeleton app containing empty modules with options
controlling objects in \code{common} and whether to include a map, code and tables
}
\examples{
td <- tempfile()
dir.create(td, recursive = TRUE)

modules <- data.frame(
"component" = c("data", "data", "plot", "plot"),
"long_component" = c("Load data", "Load data", "Plot data", "Plot data"),
"module" = c("user", "database", "histogram", "scatter"),
"long_module" = c("Upload your own data", "Query a database to obtain data",
"Plot the data as a histogram", "Plot the data as a scatterplot"),
"map" = c(TRUE, TRUE, FALSE, FALSE),
"result" = c(FALSE, FALSE, TRUE, TRUE),
"rmd" = c(TRUE, TRUE, TRUE, TRUE),
"save" = c(TRUE, TRUE, TRUE, TRUE),
"download" = c(FALSE, FALSE, TRUE, TRUE),
"async" = c(TRUE, FALSE, FALSE, FALSE))

common_objects = c("raster", "histogram", "scatter")

create_template(path = td, name = "demo",
common_objects = common_objects, modules = modules,
author = "Simon E. H. Smart", include_map = TRUE, include_table = TRUE,
include_code = TRUE, install = FALSE)

}
\author{
Simon E. H. Smart \href{mailto:simon.smart@cantab.net}{simon.smart@cantab.net}
}
