% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-slider.R
\name{material_slider}
\alias{material_slider}
\title{Create a shinymaterial slider}
\usage{
material_slider(input_id, label, min_value, max_value, step_size = 1,
  initial_value, color = NULL)
}
\arguments{
\item{input_id}{String. The input identifier used to access the value.}

\item{label}{String. The slider label.}

\item{min_value}{Number. The minimum value on the slider.}

\item{max_value}{Number. The maximum value on the slider.}

\item{step_size}{Number. The size of step in the slider.}

\item{initial_value}{Number. The initial value of the slider.}

\item{color}{String. The slider color. Leave empty for the default color. Visit \url{http://materializecss.com/color.html} for a list of available colors. \emph{This input requires using color hex codes, rather than the word form. E.g., "#ef5350", rather than "red lighten-1".}}
}
\description{
Build a shinymaterial slider.
}
\examples{
material_slider(
  input_id = "example_slider",
  label = "slider",
  min_value = 5,
  max_value = 15,
  initial_value = 10,
  step_size = 3,
  color = "#ef5350"
)
}
\seealso{
\code{\link{update_material_slider}}
}
