% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsFunc-runjs.R
\name{runjs}
\alias{runjs}
\title{Run JavaScript code}
\usage{
runjs(...)
}
\arguments{
\item{...}{The following parameters are available:
\tabular{ll}{
  \strong{\code{code}}  \tab JavaScript code to run.
}}
}
\description{
Run arbitrary JavaScript code. This is mainly useful when developing and
debugging a Shiny app, as it is generally considered dangerous to expose
a way for end users to evaluate arbitrary code.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      useShinyjs(),  # Set up shinyjs
      shiny::actionButton("btn", "Click me")
    ),
    server = function(input, output) {
      shiny::observeEvent(input$btn, {
        # Run JS code that simply shows a message
        runjs("var today = new Date(); alert(today);")
      })
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}}
}

