% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/onclick.R
\name{onclick}
\alias{onclick}
\title{Run R code when an element is clicked}
\usage{
onclick(id, expr, add = FALSE)
}
\arguments{
\item{id}{The id of the element/Shiny tag}

\item{expr}{The R expression to run after the element gets clicked}

\item{add}{If \code{TRUE}, then add \code{expr} to be executed after any
other code that was previously set using \code{onclick}; otherwise
\code{expr} will overwrite any previous onclick expressions. This parameter
works well in browsers but is buggy when using the RStudio Viewer.}
}
\description{
Run an R expression (either a \code{shinyjs} function or any other code)
when an element is clicked.  The most sensible use case is to run code after
clicking a button or a link, but this function can be used on any other
HTML element as well.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
# Note these examples use several other shinyjs functions as the onclick code
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      useShinyjs(),  # Set up shinyjs
      shiny::actionButton("btn", "Click me"),
      shiny::p(id = "element", "Click me to change my text")
    ),
    server = function(input, output, session) {
      # Change the following lines for more examples
      onclick("btn", info(date()))
      onclick("element", text("element", "Hello!"))
    }
  )
}
\dontrun{
  # The shinyjs function call in the above app can be replaced by
  # any of the following examples to produce similar Shiny apps
  onclick("btn", toggle("element"))
  onclick(expr = text("element", date()), id = "btn")
  {onclick("btn", info(date())); onclick("btn", info("Another message"), TRUE)}
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{runExample}}
}

