% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullscreen_all.R
\name{fullscreen_all}
\alias{fullscreen_all}
\title{Enable fullscreen for the whole page}
\usage{
fullscreen_all(click_id = NULL, bg_color = "#fff")
}
\arguments{
\item{click_id}{Id of the item that triggers the fullscreen view. This is a mandatory argument. You can specify the id of a button for instance, so that clicking on this button triggers the fullscreen view for the whole page.}

\item{bg_color}{Background color when item is displayed fullscreen. Default is white.}
}
\value{
Enables the whole page to be displayed in fullscreen mode.
}
\description{
Enable fullscreen for the whole page
}
\examples{
if (interactive()) {
### Only works in browser

library(shiny)

ui <- fluidPage(
  actionButton("test", "test"),
  plotOutput("plot"),
  fullscreen_all(click_id = "test")
)

server <- function(input, output, session) {

  output$plot <- renderPlot(plot(mtcars))

}

shinyApp(ui, server, options = list(launch.browser = TRUE))
}
}
