% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyfilter.r
\name{update_tooltips}
\alias{update_tooltips}
\title{Update the tooltips/popovers based on the currently available filter
  options}
\usage{
update_tooltips(
  react_id,
  session,
  tooltip = TRUE,
  show_avail = TRUE,
  title_avail = "Available values:",
  title_nonavail = "Currently not available filters:",
  popover_title = "Filter options",
  max_avail = NULL,
  max_nonavail = max_avail,
  more_avail = "... (# more)",
  more_nonavail = "... (# more)",
  placement = "top"
)
}
\arguments{
\item{react_id}{The output variable/ID of the \code{reactable} to which the
filters are linked.}

\item{session}{The session variable provided as an argument to the server
function.}

\item{tooltip}{If \code{TRUE}, tooltips will be shown. If \code{FALSE},
popovers will be shown.}

\item{show_avail}{If \code{TRUE} not only the unavailable filter options will
be listed in the tooltips/popovers, but the unavailable ones as well.}

\item{title_avail}{Header text for the list of available filter options.}

\item{title_nonavail}{Header text for the list of unavailable filter options.}

\item{popover_title}{Title text for the popover window. Only relevant when
\code{tooltips = FALSE}.}

\item{max_avail}{Maximum number of available filter options shown. Use the
\code{more_avail} argument to determine what is shown if the number of
available filter options exceeds \code{max_avail}.}

\item{max_nonavail}{Maximum number of non-available filter options shown. Use
the \code{more_nonavail} argument to determine what is shown if the number
of non-available filter options exceeds \code{max_nonavail}.}

\item{more_avail}{Text to be shown if \code{show_avail = TRUE} and the number
of available filter options exceeds \code{max_avail}. In this case, only
the first \code{max_avail} filter options are shown followed by
\code{more_avail}. In \code{more_avail} you can use \code{#} as a
placeholder for the number of filter options exceeding \code{max_avail}.}

\item{more_nonavail}{Text to be shown if the number of available filter
options exceeds \code{max_nonavail}. In this case, only the first
\code{max_nonavail} filter options are shown followed by
\code{more_nonavail}. In \code{more_nonavail} you can use \code{#} as a
placeholder for the number of filter options exceeding \code{max_nonavail}.}

\item{placement}{Defines where the tooltip/popover is placed relative to the
filter (i.e. \code{selectizeInput} widget) it belongs to. Can be either
\code{"top"}, \code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
No return value.
}
\description{
Updates all tooltips or popovers for \code{shinyfilter} filter
  \code{selectizeInput} widgets. Tooltips/popovers can be used to show the
  currently unavailable filter options, i.e. the filter options that are not
  available at the moment because of the dataframe presented in the
  \code{reactable} is filtered by the choices made in the other filters. It
  is also possible to list the available filter options as well.

  If you want to use tooltips/popovers, you need to call
  \code{\link{use_tooltips}()} from within the UI definition of your shiny
  app.
}
\details{
For a full example of a shiny app using \code{shinyfilter} please
  call up the help for \code{\link{update_filters}()}. See the
  \code{README.md} file or the GitHub repo on
  \href{https://github.com/jsugarelli/shinyfilter}{https://github.com/jsugarelli/shinyfilter}
   for a comprehensive \code{shinyfilter} tutorial.
}
