% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxes.R
\name{boxProfile}
\alias{boxProfile}
\alias{boxProfileItem}
\title{AdminLTE2 box profile}
\usage{
boxProfile(..., image = NULL, title, subtitle = NULL, bordered = FALSE)

boxProfileItem(title, description)
}
\arguments{
\item{...}{any element such as \link{boxProfileItem}.}

\item{image}{profile image, if any.}

\item{title}{item title.}

\item{subtitle}{subtitle.}

\item{bordered}{Whether the container should have a border or not. FALSE by default.}

\item{description}{item info.}
}
\description{
\link{boxProfile} goes inside a \link{box}. Displays user information in an elegant
container.

\link{boxProfileItem} is an sub-element of a \link{boxProfile}.
}
\examples{

# Box with boxProfile
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Box with profile",
      status = "primary",
      boxProfile(
       image = "https://adminlte.io/themes/AdminLTE/dist/img/user4-128x128.jpg",
       title = "Nina Mcintire",
       subtitle = "Software Engineer",
       bordered = TRUE,
       boxProfileItem(
        title = "Followers",
        description = 1322
       ),
       boxProfileItem(
        title = "Following",
        description = 543
       ),
       boxProfileItem(
        title = "Friends",
        description = 13287
       )
      )
     )
    ),
    title = "boxProfile"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
