% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{socialButton}
\alias{socialButton}
\title{AdminLTE2 social button}
\usage{
socialButton(href, icon)
}
\arguments{
\item{href}{External link.}

\item{icon}{social network icon: see here for valid names \url{https://adminlte.io/themes/AdminLTE/pages/UI/buttons.html}.}
}
\description{
Create a social button
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Social Buttons",
      status = NULL,
      socialButton(
        href = "https://dropbox.com",
        icon = icon("dropbox")
      ),
      socialButton(
        href = "https://github.com",
        icon = icon("github")
      )
     )
    ),
    title = "Social Buttons"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
