% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeline.R
\name{timelineBlock}
\alias{timelineBlock}
\title{AdminLTE2 timeline block}
\usage{
timelineBlock(..., reversed = TRUE)
}
\arguments{
\item{...}{slot for timelineLabel or timelineItem.}

\item{reversed}{Whether the timeline is reversed or not.}
}
\description{
Create a timeline block
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     h3("When Reversed = TRUE, can be displayed inside a box"),
     box(
      title = "Timeline",
      status = "info",
      timelineBlock(
       timelineEnd(color = "danger"),
       timelineLabel(2018, color = "teal"),
       timelineItem(
        title = "Item 1",
        icon = "gears",
        color = "olive",
        time = "now",
        footer = "Here is the footer",
        "This is the body"
       ),
       timelineItem(
        title = "Item 2",
        border = FALSE
       ),
       timelineLabel(2015, color = "orange"),
       timelineItem(
        title = "Item 3",
        icon = "paint-brush",
        color = "maroon",
        timelineItemMedia(src = "http://placehold.it/150x100"),
        timelineItemMedia(src = "http://placehold.it/150x100")
       ),
       timelineStart(color = "gray")
      )
     ),
     
     column(
      width = 6,
      h3("When Reversed = FALSE, can be displayed out of a box"),
      timelineBlock(
       reversed = FALSE,
       timelineEnd(color = "danger"),
       timelineLabel(2018, color = "teal"),
       timelineItem(
        title = "Item 1",
        icon = "gears",
        color = "olive",
        time = "now",
        footer = "Here is the footer",
        "This is the body"
       ),
       timelineItem(
        title = "Item 2",
        border = FALSE
       ),
       timelineLabel(2015, color = "orange"),
       timelineItem(
        title = "Item 3",
        icon = "paint-brush",
        color = "maroon",
        timelineItemMedia(src = "http://placehold.it/150x100"),
        timelineItemMedia(src = "http://placehold.it/150x100")
       ),
       timelineStart(color = "gray")
      )
     )
    ),
    title = "timelineBlock"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
