% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown-stream.R
\name{output_markdown_stream}
\alias{output_markdown_stream}
\title{Create a UI element for a markdown stream.}
\usage{
output_markdown_stream(
  id,
  ...,
  content = "",
  content_type = "markdown",
  auto_scroll = TRUE,
  width = "min(680px, 100\%)",
  height = "auto"
)
}
\arguments{
\item{id}{A unique identifier for this markdown stream.}

\item{...}{Extra HTML attributes to include on the chat element}

\item{content}{A string of content to display before any streaming occurs.
When \code{content_type} is Markdown or HTML, it may also be UI element(s) such
as input and output bindings.}

\item{content_type}{The content type. Default is \code{"markdown"} (specifically,
CommonMark). Supported content types include:
* \code{"markdown"}: markdown text, specifically CommonMark
* \code{"html"}: for rendering HTML content.
* \code{"text"}: for plain text.
* \code{"semi-markdown"}: for rendering markdown, but with HTML tags escaped.}

\item{auto_scroll}{Whether to automatically scroll to the bottom of a
scrollable container when new content is added. Default is True.}

\item{width}{The width of the UI element.}

\item{height}{The height of the UI element.}
}
\value{
A shiny tag object.
}
\description{
Creates a UI element for a \code{\link[=markdown_stream]{markdown_stream()}}. A markdown stream can be
useful for displaying generative AI responses (outside of a chat interface),
streaming logs, or other use cases where chunks of content are generated
over time.
}
\seealso{
\code{\link[=markdown_stream]{markdown_stream()}}
}
