% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-awesomeradio.R
\name{updateAwesomeRadio}
\alias{updateAwesomeRadio}
\title{Change the value of a radio input on the client}
\usage{
updateAwesomeRadio(
  session = getDefaultReactiveDomain(),
  inputId,
  label = NULL,
  choices = NULL,
  selected = NULL,
  inline = FALSE,
  status = "primary",
  checkbox = FALSE
)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{inputId}{The id of the input object.}

\item{label}{Input label.}

\item{choices}{List of values to select from (if elements of the list are named then that name rather than the value is displayed to the user)}

\item{selected}{The initially selected value.}

\item{inline}{If TRUE, render the choices inline (i.e. horizontally)}

\item{status}{Color of the buttons, to update status you need to provide \code{choices}.}

\item{checkbox}{Checkbox style}
}
\description{
Change the value of a radio input on the client
}
\examples{
library(shiny)
library(shinyWidgets)


ui <- fluidPage(
  awesomeRadio(
    inputId = "radio",
    choices = c("A", "B", "C"),
    label = "My label"
  ),

  verbatimTextOutput(outputId = "res"),

  actionButton(inputId = "updatechoices", label = "Random choices"),
  textInput(inputId = "updatelabel", label = "Update label"),
  selectInput(
    inputId = "updatestatus",
    label = "Status",
    choices = c("primary", "danger", "warning", "success", "info")
  )
)

server <- function(input, output, session) {

  output$res <- renderPrint({
    input$somevalue
  })

  observeEvent(input$updatechoices, {
    updateAwesomeRadio(
      inputId = "radio",
      choices = sample(letters, sample(2:6, 1))
    )
  })

  observeEvent(input$updatelabel, {
    updateAwesomeRadio(
      inputId = "radio",
      label = input$updatelabel
    )
  }, ignoreInit = TRUE)

  # To update status you need to provide coices too
  observeEvent(input$updatestatus, {
    updateAwesomeRadio(
      inputId = "radio",
      choices = c("A", "B", "C"),
      status = input$updatestatus
    )
  }, ignoreInit = TRUE)

}

if (interactive())
  shinyApp(ui = ui, server = server)
}
\seealso{
\code{\link[=awesomeRadio]{awesomeRadio()}}
}
