% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-radiogroupbuttons.R
\name{radioGroupButtons}
\alias{radioGroupButtons}
\title{Buttons Group Radio Input Control}
\usage{
radioGroupButtons(inputId, label = NULL, choices, selected = NULL,
  status = "default", size = "normal", direction = "horizontal",
  justified = FALSE, individual = FALSE, checkIcon = list())
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Input label.}

\item{choices}{List of values to select from (if elements of the list are named then that name rather than the value is displayed to the user).}

\item{selected}{The initially selected value.}

\item{status}{Color of the buttons}

\item{size}{Size of the buttons ('xs', 'sm', 'normal', 'lg')}

\item{direction}{Horizontal or vertical}

\item{justified}{If TRUE, fill the width of the parent div}

\item{individual}{If TRUE, buttons are separated.}

\item{checkIcon}{A list, if no empty must contain at least one element named 'yes' corresponding to an icon to display if the button is checked.}
}
\value{
A buttons group control that can be added to a UI definition.
}
\description{
Create buttons grouped that act like radio buttons.
}
\examples{
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  radioGroupButtons(inputId = "somevalue", choices = c("A", "B", "C")),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderText({ input$somevalue })
}
shinyApp(ui, server)
}
}

}
