% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Button.R
\name{f7Segment}
\alias{f7Segment}
\title{Framework7 segmented button container}
\usage{
f7Segment(
  ...,
  container = c("segment", "row"),
  shadow = FALSE,
  rounded = FALSE,
  strong = FALSE
)
}
\arguments{
\item{...}{Slot for \link{f7Button}.}

\item{container}{Either "row" or "segment".}

\item{shadow}{Button shadow. FALSE by default. Only if the container is segment.}

\item{rounded}{Round style. FALSE by default. Only if the container is segment.}

\item{strong}{Strong style. FALSE by default.}
}
\description{
A Framework7 segmented button container for \link{f7Button}.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Button Segments",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Segment, f7Button"),
     f7BlockTitle(title = "Simple Buttons in a row container"),
    f7Segment(
     container = "row",
     f7Button(color = "blue", label = "My button", fill = FALSE),
     f7Button(color = "green", label = "My button", href = "https://www.google.com", fill = FALSE),
     f7Button(color = "yellow", label = "My button", fill = FALSE)
    ),
    f7BlockTitle(title = "Filled Buttons in a segment/rounded container"),
    f7Segment(
     rounded = TRUE,
     container = "segment",
     f7Button(color = "black", label = "Action Button", inputId = "button2"),
     f7Button(color = "green", label = "My button", href = "https://www.google.com"),
     f7Button(color = "yellow", label = "My button")
    ),
    f7BlockTitle(title = "Outline Buttons in a segment/shadow container"),
    f7Segment(
     shadow = TRUE,
     container = "segment",
     f7Button(label = "My button", outline = TRUE, fill = FALSE),
     f7Button(label = "My button", outline = TRUE, fill = FALSE),
     f7Button(label = "My button", outline = TRUE, fill = FALSE)
    ),
    f7BlockTitle(title = "Buttons in a segment/strong container"),
    f7Segment(
     strong = TRUE,
     container = "segment",
     f7Button(label = "My button", fill = FALSE),
     f7Button(label = "My button", fill = FALSE),
     f7Button(label = "My button", fill = FALSE, active = TRUE)
    ),
    f7BlockTitle(title = "Rounded Buttons in a segment container"),
    f7Segment(
     container = "segment",
     f7Button(color = "blue", label = "My button", rounded = TRUE),
     f7Button(color = "green", label = "My button", rounded = TRUE),
     f7Button(color = "yellow", label = "My button", rounded = TRUE)
    ),
    f7BlockTitle(title = "Buttons of different size in a row container"),
    f7Segment(
     container = "row",
     f7Button(color = "pink", label = "My button", shadow = TRUE),
     f7Button(color = "purple", label = "My button", size = "large", shadow = TRUE),
     f7Button(color = "orange", label = "My button", size = "small", shadow = TRUE)
    ),

    br(), br(),
    f7BlockTitle(title = "Click on the black action button to update the value"),
    verbatimTextOutput("val")
    )
  ),
  server = function(input, output) {
   output$val <- renderPrint(input$button2)
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
