% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Picker}
\alias{updateF7Picker}
\title{Change the value of a picker input on the client}
\usage{
updateF7Picker(session, inputId, value = NULL, choices = NULL)
}
\arguments{
\item{session}{The session object passed to function given to the server.}

\item{inputId}{The id of the input object.}

\item{value}{Picker initial value, if any.}

\item{choices}{New picker choices.}
}
\description{
Change the value of a picker input on the client
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update picker"),
      f7Card(
        f7Button(inputId = "update", label = "Update picker"),
        f7Picker(
          inputId = "mypicker",
          placeholder = "Some text here!",
          label = "Picker Input",
          choices = c('a', 'b', 'c')
        ),
        verbatimTextOutput("pickerval")
      )
    )
  ),
  server = function(input, output, session) {

    output$pickerval <- renderText(input$mypicker)

    observeEvent(input$update, {
      updateF7Picker(
        session,
        inputId = "mypicker",
        value = "b",
        choices = letters
      )
    })
  }
 )
}
}
