% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_max_aggregator.R
\docType{class}
\name{min_max_aggregator}
\alias{min_max_aggregator}
\title{Aggregation using local minimum and maximum values.}
\format{
An \code{R6::R6Class} object
}
\description{
Divide the data into small data ranges
and find the maximum and minimum values of each.
\code{n_out} must be even number.
}
\examples{
data(noise_fluct)
agg <- min_max_aggregator$new()
d_agg <- agg$aggregate(noise_fluct$sec, noise_fluct$level, 1000)
plot(d_agg$x, d_agg$y, type = "l")

}
\section{Super class}{
\code{\link[shinyHugePlot:aggregator]{shinyHugePlot::aggregator}} -> \code{min_max_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-min_max_aggregator-new}{\code{min_max_aggregator$new()}}
\item \href{#method-min_max_aggregator-clone}{\code{min_max_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-min_max_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-min_max_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{min_max_aggregator$new(interleave_gaps = FALSE, nan_position = "end", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, nan_position}}{Arguments pass to \code{aggregator$new}.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-min_max_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-min_max_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{min_max_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
