% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregators.R
\docType{class}
\name{eLTTB_aggregator}
\alias{eLTTB_aggregator}
\title{Aggregation using local minimum and maximum values,
and Largest Triangle Three Buckets (LTTB) method.}
\format{
An \code{R6::R6Class} object
}
\description{
Efficient version off LTTB
by first reducing really large data with the \code{min_max_ovlp_aggregator}
and then further aggregating the reduced result with \code{LTTB_aggregator}.
}
\examples{
data(noise_fluct)
agg <- eLTTB_aggregator$new()
d_agg <- agg$aggregate(noise_fluct$sec, noise_fluct$level, 1000)
plot(d_agg$x, d_agg$y, type = "l")

}
\section{Super class}{
\code{\link[shinyHugePlot:abstract_aggregator]{shinyHugePlot::abstract_aggregator}} -> \code{eLTTB_aggregator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{LTTB}}{An R6 LTTB_aggregator instance}

\item{\code{minmax}}{An R6 \code{min_max_ovlp_aggregator} instance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-eLTTB_aggregator-new}{\code{eLTTB_aggregator$new()}}
\item \href{#method-eLTTB_aggregator-clone}{\code{eLTTB_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/abstract_aggregator.html#method-abstract_aggregator-aggregate'><code>shinyHugePlot::abstract_aggregator$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-eLTTB_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-eLTTB_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{eLTTB_aggregator$new(interleave_gaps = FALSE, nan_position = "end")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, nan_position}}{Arguments pass to the constructor of
the \code{abstract_aggregator} class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-eLTTB_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-eLTTB_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{eLTTB_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
