% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregators.R
\docType{class}
\name{range_stat_aggregator}
\alias{range_stat_aggregator}
\title{R6 Class for aggregation which returns the 3 types of the statistical values}
\format{
An \code{R6::R6Class} object
}
\description{
This aggregator divides the data into no-overlapping intervals
and calculate specific statistical values such as the mean.
}
\examples{
data(noise_fluct)
agg <- range_stat_aggregator$new(ylwr = min, y = mean, yupr = max)
d_agg <- agg$aggregate(noise_fluct$sec, noise_fluct$level, 1000)
plot(d_agg$x, d_agg$ylwr, type = "l")
plot(d_agg$x, d_agg$y, type = "l")
plot(d_agg$x, d_agg$yupr, type = "l")

}
\section{Super class}{
\code{\link[shinyHugePlot:abstract_aggregator]{shinyHugePlot::abstract_aggregator}} -> \code{custom_stat_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-custom_stat_aggregator-new}{\code{range_stat_aggregator$new()}}
\item \href{#method-custom_stat_aggregator-clone}{\code{range_stat_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/abstract_aggregator.html#method-abstract_aggregator-aggregate'><code>shinyHugePlot::abstract_aggregator$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_stat_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-custom_stat_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{range_stat_aggregator$new(
  ylwr = function(x) min(x, na.rm = TRUE),
  y = function(x) mean(x, na.rm = TRUE),
  yupr = function(x) max(x, na.rm = TRUE),
  interleave_gaps = FALSE,
  nan_position = "end"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{yupr, y, ylwr}}{Functions.
Statistical values are calculated using this function.
By default, \code{max, mean, min}, respectively.
Note that the functions need to deal with NA values.}

\item{\code{interleave_gaps, nan_position}}{Arguments pass to the constructor of
the \code{abstract_aggregator} class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_stat_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-custom_stat_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{range_stat_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
