% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jseval_and_hooks.R
\name{useDisclosure}
\alias{useDisclosure}
\title{The `useDisclosure` hook}
\usage{
useDisclosure(defaultIsOpen = FALSE)
}
\arguments{
\item{defaultIsOpen}{Boolean, the initial value of the \code{isOpen} property}
}
\value{
A list containing some URL-encoded JavaScript code.
}
\description{
The `useDisclosure` hook.
}
\details{
See \href{https://chakra-ui.com/docs/hooks/use-disclosure}{useDisclosure}.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    withStates(
      Tag$Fragment(

        Tag$Button(
          colorScheme = "teal",
          variant = "outline",
          onClick = getHookProperty("disclosure", "onToggle"),
          "Click me!"
        ),

        Tag$Fade(
          "in" = getHookProperty("disclosure", "isOpen"),
          Tag$Box(
            p = "40px",
            color = "white",
            mt = "4",
            bg = "teal.500",
            rounded = "md",
            shadow = "md",
            "Fade"
          )
        )

      ),

      states = list(disclosure = useDisclosure())
    )

  )

)

server <- function(input, output, session){}

if(interactive()){
  shinyApp(ui, server)
}
}
\seealso{
\code{\link{getHookProperty}}
}
