% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakra.R
\name{withStates}
\alias{withStates}
\title{Chakra component with states or hooks}
\usage{
withStates(component, states)
}
\arguments{
\item{component}{a React component}

\item{states}{named list of states; a state value can be an R object
serializable to JSON, a React component (\code{Tag$Component(...)}),
a Shiny widget, some HTML code defined by the
\code{\link[htmltools:HTML]{HTML}} function, a JSX element defined by
the \code{\link{jsx}} function, a JavaScript value defined by the
\code{\link{jseval}} function, or a hook such as \code{useDisclosure()}
(see \code{\link{useDisclosure}}).}
}
\value{
A component to use in \code{\link{chakraComponent}}.
}
\description{
Create a Chakra component with React states and/or hooks.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    withStates(

      Tag$Fragment(

        Tag$Container(
          maxW = "xl",
          centerContent = TRUE,
          bg = "orange.50",
          Tag$Heading(
            getState("heading")
          ),
          Tag$Text(
            "I'm just some text."
          )
        ),

        br(),
        Tag$Divider(),
        br(),

        Tag$Button(
          colorScheme = "twitter",
          display = "block",
          onClick = jseval(
            "() => setState('heading', 'I am the new heading.')"
          ),
          "Click me to change the heading"
        )

      ),

      states = list(heading = "I am the heading.")

    )

  )

)

server <- function(input, output, session){}

if(interactive()){
  shinyApp(ui, server)
}
}
