% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrapPage}
\alias{bootstrapPage}
\alias{basicPage}
\title{Create a Bootstrap page}
\usage{
bootstrapPage(..., title = NULL, theme = NULL, lang = NULL)

basicPage(...)
}
\arguments{
\item{...}{The contents of the document body.}

\item{title}{The browser window title (defaults to the host URL of the page)}

\item{theme}{One of the following:
\itemize{
\item \code{NULL} (the default), which implies a "stock" build of Bootstrap 3.
\item A \code{\link[bslib:bs_theme]{bslib::bs_theme()}} object. This can be used to replace a stock
build of Bootstrap 3 with a customized version of Bootstrap 3 or higher.
\item A character string pointing to an alternative Bootstrap stylesheet
(normally a css file within the www directory, e.g. \code{www/bootstrap.css}).
}}

\item{lang}{ISO 639-1 language code for the HTML page, such as "en" or "ko".
This will be used as the lang in the \code{<html>} tag, as in \code{<html lang="en">}.
The default (NULL) results in an empty string.}
}
\value{
A UI defintion that can be passed to the \link{shinyUI} function.
}
\description{
Create a Shiny UI page that loads the CSS and JavaScript for
\href{https://getbootstrap.com/}{Bootstrap}, and has no content in the page
body (other than what you provide).
}
\details{
This function is primarily intended for users who are proficient in HTML/CSS,
and know how to lay out pages in Bootstrap. Most applications should use
\code{\link[=fluidPage]{fluidPage()}} along with layout functions like
\code{\link[=fluidRow]{fluidRow()}} and \code{\link[=sidebarLayout]{sidebarLayout()}}.
}
\note{
The \code{basicPage} function is deprecated, you should use the
\code{\link[=fluidPage]{fluidPage()}} function instead.
}
\seealso{
\code{\link[=fluidPage]{fluidPage()}}, \code{\link[=fixedPage]{fixedPage()}}
}
