% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{fillPage}
\alias{fillPage}
\title{Create a page that fills the window}
\usage{
fillPage(
  ...,
  padding = 0,
  title = NULL,
  bootstrap = TRUE,
  theme = NULL,
  lang = NULL
)
}
\arguments{
\item{...}{Elements to include within the page.}

\item{padding}{Padding to use for the body. This can be a numeric vector
(which will be interpreted as pixels) or a character vector with valid CSS
lengths. The length can be between one and four. If one, then that value
will be used for all four sides. If two, then the first value will be used
for the top and bottom, while the second value will be used for left and
right. If three, then the first will be used for top, the second will be
left and right, and the third will be bottom. If four, then the values will
be interpreted as top, right, bottom, and left respectively.}

\item{title}{The title to use for the browser window/tab (it will not be
shown in the document).}

\item{bootstrap}{If \code{TRUE}, load the Bootstrap CSS library.}

\item{theme}{URL to alternative Bootstrap stylesheet.}

\item{lang}{ISO 639-1 language code for the HTML page, such as "en" or "ko".
This will be used as the lang in the \code{<html>} tag, as in \code{<html lang="en">}.
The default (NULL) results in an empty string.}
}
\description{
\code{fillPage} creates a page whose height and width always fill the
available area of the browser window.
}
\details{
The \code{\link[=fluidPage]{fluidPage()}} and \code{\link[=fixedPage]{fixedPage()}} functions are used
for creating web pages that are laid out from the top down, leaving
whitespace at the bottom if the page content's height is smaller than the
browser window, and scrolling if the content is larger than the window.

\code{fillPage} is designed to latch the document body's size to the size of
the window. This makes it possible to fill it with content that also scales
to the size of the window.

For example, \code{fluidPage(plotOutput("plot", height = "100\%"))} will not
work as expected; the plot element's effective height will be \code{0},
because the plot's containing elements (\verb{<div>} and \verb{<body>}) have
\emph{automatic} height; that is, they determine their own height based on
the height of their contained elements. However,
\code{fillPage(plotOutput("plot", height = "100\%"))} will work because
\code{fillPage} fixes the \verb{<body>} height at 100\% of the window height.

Note that \code{fillPage(plotOutput("plot"))} will not cause the plot to fill
the page. Like most Shiny output widgets, \code{plotOutput}'s default height
is a fixed number of pixels. You must explicitly set \code{height = "100\%"}
if you want a plot (or htmlwidget, say) to fill its container.

One must be careful what layouts/panels/elements come between the
\code{fillPage} and the plots/widgets. Any container that has an automatic
height will cause children with \code{height = "100\%"} to misbehave. Stick
to functions that are designed for fill layouts, such as the ones in this
package.
}
\examples{
fillPage(
  tags$style(type = "text/css",
    ".half-fill { width: 50\%; height: 100\%; }",
    "#one { float: left; background-color: #ddddff; }",
    "#two { float: right; background-color: #ccffcc; }"
  ),
  div(id = "one", class = "half-fill",
    "Left half"
  ),
  div(id = "two", class = "half-fill",
    "Right half"
  ),
  padding = 10
)

fillPage(
  fillRow(
    div(style = "background-color: red; width: 100\%; height: 100\%;"),
    div(style = "background-color: blue; width: 100\%; height: 100\%;")
  )
)
}
\seealso{
Other layout functions: 
\code{\link{fixedPage}()},
\code{\link{flowLayout}()},
\code{\link{fluidPage}()},
\code{\link{navbarPage}()},
\code{\link{sidebarLayout}()},
\code{\link{splitLayout}()},
\code{\link{verticalLayout}()}
}
\concept{layout functions}
