% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{viewer}
\alias{viewer}
\alias{paneViewer}
\alias{dialogViewer}
\alias{browserViewer}
\title{Viewer options}
\usage{
paneViewer(minHeight = NULL)

dialogViewer(dialogName, width = 600, height = 600)

browserViewer(browser = getOption("browser"))
}
\arguments{
\item{minHeight}{The minimum height (in pixels) desired to show the gadget in
the viewer pane. If a positive number, resize the pane if necessary to show
at least that many pixels. If \code{NULL}, use the existing viewer pane
size. If \code{"maximize"}, use the maximum available vertical space.}

\item{dialogName}{The window title to display for the dialog.}

\item{width, height}{The desired dialog width/height, in pixels.}

\item{browser}{See \code{\link[utils:browseURL]{utils::browseURL()}}.}
}
\value{
A function that takes a single \code{url} parameter, suitable for
passing as the \code{viewer} argument of \code{\link[=runGadget]{runGadget()}}.
}
\description{
Use these functions to control where the gadget is displayed in RStudio (or
other R environments that emulate RStudio's viewer pane/dialog APIs). If
viewer APIs are not available in the current R environment, then the gadget
will be displayed in the system's default web browser (see
\code{\link[utils:browseURL]{utils::browseURL()}}).
}
