% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bootstrap.R, R/slider.R
\name{sliderInput}
\alias{animationOptions}
\alias{sliderInput}
\title{Slider Input Widget}
\usage{
sliderInput(inputId, label, min, max, value, step = NULL, round = FALSE,
  format = NULL, locale = NULL, ticks = TRUE, animate = FALSE,
  width = NULL, sep = ",", pre = NULL, post = NULL)

animationOptions(interval = 1000, loop = FALSE, playButton = NULL,
  pauseButton = NULL)
}
\arguments{
\item{inputId}{Specifies the \code{input} slot that will be used to access
the value.}

\item{label}{A descriptive label to be displayed with the widget, or
\code{NULL}.}

\item{min}{The minimum value (inclusive) that can be selected.}

\item{max}{The maximum value (inclusive) that can be selected.}

\item{value}{The initial value of the slider. A numeric vector of length
one will create a regular slider; a numeric vector of length two will
create a double-ended range slider. A warning will be issued if the
value doesn't fit between \code{min} and \code{max}.}

\item{step}{Specifies the interval between each selectable value on the
slider (if \code{NULL}, a heuristic is used to determine the step size).}

\item{round}{\code{TRUE} to round all values to the nearest integer;
\code{FALSE} if no rounding is desired; or an integer to round to that
number of digits (for example, 1 will round to the nearest 10, and -2 will
round to the nearest .01). Any rounding will be applied after snapping to
the nearest step.}

\item{format}{Deprecated.}

\item{locale}{Deprecated.}

\item{ticks}{\code{FALSE} to hide tick marks, \code{TRUE} to show them
according to some simple heuristics.}

\item{animate}{\code{TRUE} to show simple animation controls with default
settings; \code{FALSE} not to; or a custom settings list, such as those
created using \code{\link{animationOptions}}.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link{validateCssUnit}}.}

\item{sep}{Separator between thousands places in numbers.}

\item{pre}{A prefix string to put in front of the value.}

\item{post}{A suffix string to put after the value.}

\item{interval}{The interval, in milliseconds, between each animation step.}

\item{loop}{\code{TRUE} to automatically restart the animation when it
reaches the end.}

\item{playButton}{Specifies the appearance of the play button. Valid values
are a one-element character vector (for a simple text label), an HTML tag
or list of tags (using \code{\link{tag}} and friends), or raw HTML (using
\code{\link{HTML}}).}

\item{pauseButton}{Similar to \code{playButton}, but for the pause button.}
}
\description{
Constructs a slider widget to select a numeric value from a range.
}
\seealso{
\code{\link{updateSliderInput}}

Other input.elements: \code{\link{actionButton}},
  \code{\link{actionLink}};
  \code{\link{checkboxGroupInput}};
  \code{\link{checkboxInput}}; \code{\link{dateInput}};
  \code{\link{dateRangeInput}}; \code{\link{fileInput}};
  \code{\link{numericInput}}; \code{\link{passwordInput}};
  \code{\link{radioButtons}}; \code{\link{selectInput}},
  \code{\link{selectizeInput}}; \code{\link{submitButton}};
  \code{\link{textInput}}
}

