% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{file_input}
\alias{file_input}
\alias{fileInput}
\title{Create Semantic UI File Input}
\usage{
file_input(
  input_id,
  label,
  multiple = FALSE,
  accept = NULL,
  button_label = "Browse...",
  type = NULL,
  placeholder = "no file selected",
  ...
)

fileInput(
  inputId,
  label,
  multiple = FALSE,
  accept = NULL,
  width = NULL,
  buttonLabel = "Browse...",
  placeholder = "No file selected",
  ...
)
}
\arguments{
\item{input_id, inputId}{Input name. Reactive value is available under \code{input[[input_id]]}.}

\item{label}{Display label for the control, or NULL for no label.}

\item{multiple}{Whether the user should be allowed to select and upload multiple files at once.}

\item{accept}{A character vector of "unique file type specifiers" which gives the browser a hint as to the type
of file the server expects. Many browsers use this prevent the user from selecting an invalid file.}

\item{button_label, buttonLabel}{Display label for the button.}

\item{type}{Input type specifying class attached to input container.
See [Fomantic UI](https://fomantic-ui.com/collections/form.html) for details.}

\item{placeholder}{Inner input label displayed when no file has been uploaded.}

\item{...}{Other parameters passed from \code{fileInput} to \code{file_input} like \code{type}.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'}.}
}
\description{
This creates a default file input using Semantic UI. The input is available
under \code{input[[input_id]]}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
  library(shiny)
  library(shiny.semantic)
  ui <- semanticPage(
    form(
      div(
        class = "ui grid",
        div(
          class = "four wide column",
          file_input("ex", "Select file"),
          header("File type selected:", textOutput("ex_file"))
        )
      )
    )
  )
  server <- function(input, output, session) {
    output$ex_file <- renderText({
      if (is.null(input)) return("No file uploaded")
      tools::file_ext(input$ex$datapath)
    })
  }
  shinyApp(ui, server)
}

}
