% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{numeric_input}
\alias{numeric_input}
\alias{numericInput}
\title{Create Semantic UI Numeric Input}
\usage{
numeric_input(
  input_id,
  label,
  value,
  min = NA,
  max = NA,
  step = NA,
  type = NULL,
  icon = NULL,
  placeholder = NULL,
  ...
)

numericInput(
  inputId,
  label,
  value,
  min = NA,
  max = NA,
  step = NA,
  width = NULL,
  ...
)
}
\arguments{
\item{input_id}{Input name. Reactive value is available under \code{input[[input_id]]}.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value of the numeric input.}

\item{min}{Minimum allowed value.}

\item{max}{Maximum allowed value.}

\item{step}{Interval to use when stepping between min and max.}

\item{type}{Input type specifying class attached to input container.
See [Fomantic UI](https://fomantic-ui.com/collections/form.html) for details.}

\item{icon}{Icon or label attached to numeric input.}

\item{placeholder}{Inner input label displayed when no value is specified.}

\item{...}{Other parameters passed to \code{\link{numeric_input}} like \code{type} or \code{icon}.}

\item{inputId}{The input slot that will be used to access the value.}

\item{width}{The width of the input.}
}
\description{
This creates a default numeric input using Semantic UI. The input is available
under \code{input[[input_id]]}.
}
\details{
The inputs are updateable by using \code{\link{updateNumericInput}}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
  library(shiny)
  library(shiny.semantic)
  ui <- semanticPage(
    numeric_input("ex", "Select number", 10),
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}

}
