% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{grid_container_css}
\alias{grid_container_css}
\title{Generate template string representing CSS styles of grid container div.}
\usage{
grid_container_css(css_grid_template_areas, rows_height, cols_width)
}
\arguments{
\item{css_grid_template_areas}{character, CSS value for grid-template-areas}

\item{rows_height}{vector of character}

\item{cols_width}{vector of character}
}
\value{
character
}
\description{
Generate template string representing CSS styles of grid container div.
}
\details{
This is a helper function used in grid_template()
\preformatted{
  grid_container_css(
    "'a a a' 'b b b'",
    c("50\%", "50\%"),
    c("100px", "2fr", "1fr")
  )
}
returns
\preformatted{
  "display: grid;
   height: 100\%;
   grid-template-rows: 50\% 50\%;
   grid-template-columns: 100px 2fr 1fr;
   grid-template-areas: 'a a a' 'b b b';
   {custom_style_grid_container}"
}
}
