% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translator.R
\docType{class}
\name{translator}
\alias{translator}
\alias{Translator}
\title{Translator class}
\value{
Translator object (for all possible methods look at Methods section)
}
\description{
Translator class
}
\section{Fields}{

\describe{
\item{\code{languages}}{character vector with all languages}

\item{\code{options}}{list with options from configuration file}

\item{\code{translations}}{data.frame with translations}

\item{\code{translation_language}}{character current translation language}

\item{\code{mode}}{determines whether data was read from "csv" or "json" files.}
}}

\section{Methods}{

\describe{
\item{\code{parse_date(date)}}{Parse date to format described in 'cultural_date_format' field in config.}

\item{\code{parse_number(number)}}{Parse numbers (to be implemented).}

\item{\code{set_translation_language(transl_language)}}{Specify language of translation. It must exist in 'languages' field.}

\item{\code{t(keyword)}}{Wrapper method. Look at 'translate'}

\item{\code{translate(keyword)}}{Translates 'keyword' to language specified by 'set_translation_language'}
}}

\examples{
\dontrun{
  i18n <- Translator(translation_json_path = "translation.json") # translation file
  i18n$set_translation_language("it")
  i18n$t("This text will be translated to italian")
}
}
