% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared-session.R
\name{javascript-tunnel}
\alias{javascript-tunnel}
\alias{register_session_id}
\alias{register_session_events}
\alias{get_theme}
\alias{get_jsevent}
\title{The 'JavaScript' tunnel}
\usage{
register_session_id(
  session = shiny::getDefaultReactiveDomain(),
  shared_id = NULL,
  shared_inputs = NA
)

register_session_events(session = shiny::getDefaultReactiveDomain())

get_theme(event_data, session = shiny::getDefaultReactiveDomain())

get_jsevent(
  event_data,
  type,
  default = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{session}{shiny reactive domain}

\item{shared_id}{the shared id of the session, usually automatically set}

\item{shared_inputs}{the input names to share to/from other sessions}

\item{event_data}{a reactive value list returned by
\code{register_session_events}}

\item{type}{event type; see 'Details'}

\item{default}{default value if \code{type} is missing}
}
\value{
\code{register_session_id} returns a list of function to control
"sharing" inputs with other shiny sessions with the same \code{shared_id}.
\code{register_session_events} returns a reactive value list that reflects
the session state.
\code{get_jsevent} returns events fired by
\code{shidashi.broadcastEvent} in 'JavaScript'.
\code{get_theme} returns a list of theme, foreground, and background color.
}
\description{
The 'JavaScript' tunnel
}
\details{
The \code{register_session_id} should be used in the module
server function. It registers a \code{shared_id} and a \code{private_id}
to the session. The sessions with the same \code{shared_id} can synchronize
their inputs, specified by \code{shared_inputs} even on different browser
tabs.

\code{register_session_events} will read the session events from 'JavaScript'
and passively update these information. Any the event fired by
\code{shidashi.broadcastEvent} in 'JavaScript' will be available as
reactive value. \code{get_jsevent} provides a convenient way to read
these events provided the right
event types. \code{get_theme} is a special \code{get_jsevent} that with
event type \code{"theme.changed"}.

Function \code{register_session_id} and \code{register_session_events}
should be called at the beginning of server functions. They can be
called multiple times safely. Function
\code{get_jsevent} and \code{get_theme} should be called in reactive
contexts (such as \code{\link[shiny]{observe}},
\code{\link[shiny]{observeEvent}}).
}
\examples{

# shiny server function

library(shiny)
server <- function(input, output, session){
  sync_tools <- register_session_id(session = session)
  event_data <- register_session_events(session = session)

  # if you want to enable syncing. They are suspended by default
  sync_tools$enable_broadcast()
  sync_tools$enable_sync()

  # get_theme should be called within reactive context
  output$plot <- renderPlot({
    theme <- get_theme(event_data)
    mar(bg = theme$background, fg = theme$foreground)
    plot(1:10)
  })

}

}
