% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{calcBaseline}
\alias{calcBaseline}
\title{Calculate the BASELINe PDFs}
\usage{
calcBaseline(db, sequenceColumn = "SEQUENCE_IMGT",
  germlineColumn = "GERMLINE_IMGT_D_MASK", testStatistic = c("local",
  "focused", "imbalance"), regionDefinition = NULL,
  targetingModel = HS5FModel, calcStats = FALSE, nproc = 1)
}
\arguments{
\item{db}{\code{data.frame} containing sequence data and annotations.}

\item{sequenceColumn}{\code{character} name of the column in \code{db} 
containing input sequences.}

\item{germlineColumn}{\code{character} name of the column in \code{db} 
containing germline sequences.}

\item{testStatistic}{\code{character} indicating the statistical framework 
used to test for selection. One of \code{c("local", "focused", "imbalance")}.}

\item{regionDefinition}{\link{RegionDefinition} object defining the regions
and boundaries of the Ig sequences.}

\item{targetingModel}{\link{TargetingModel} object. Default is  \link{HS5FModel}.}

\item{calcStats}{\code{logical} indicating whether or not to calculate the 
summary statistics \code{data.frame} stored in the 
\code{stats} slot of a \link{Baseline} object.}

\item{nproc}{number of cores to distribute the operation over. If 
\code{nproc} = 0 then the \code{cluster} has already been
set and will not be reset.}
}
\value{
A \code{Baseline} object containing the modified \code{db} and BASELINe 
         posterior probability density functions (PDF) for each of the sequences.
}
\description{
\code{calcBaseline} calculates the BASELINe posterior probability density 
functions (PDFs) for sequences in the given Change-O \code{data.frame}.
}
\details{
Calculates the BASELINe posterior probability density function (PDF) for 
sequences in the provided \code{db}. 
         
If the \code{db} does not contain the 
required columns to calculate the PDFs (namely OBSERVED & EXPECTED mutations)
then the function will:
  \enumerate{
  \item  Collapse the sequences by the CLONE column (if present).
  \item  Calculate the numbers of observed mutations.
  \item  Calculate the expected frequencies of mutations and modify the provided 
         \code{db}. The modified \code{db} will be included as part of the 
         returned \code{Baseline} object).
}

The \code{testStatistic} indicates the statistical framework used to test for selection. 
E.g.
\itemize{
  \item   \code{local} = CDR_R / (CDR_R + CDR_S).
  \item   \code{focused} = CDR_R / (CDR_R + CDR_S + FWR_S).
  \item   \code{imbalance} = CDR_R + CDR_S / (CDR_R + CDR_S + FWR_S + FRW_R).
}
For \code{focused} the \code{regionDefinition} must only contain two regions. If more 
than two regions are defined the \code{local} test statistic will be used.
For further information on the frame of these tests see Uduman et al. (2011).
}
\examples{
# Subset example data
db <- subset(InfluenzaDb, CPRIMER \%in\% c("IGHA","IGHM") & 
                          BARCODE \%in\% c("RL016","RL018","RL019","RL021"))

# Calculate BASELINe
# By default, calcBaseline collapses the sequences in the db by the column "CLONE",
# calculates the numbers of observed mutations and expected frequencies of mutations,
# as defined in the IMGT_V_NO_CDR3 and using the HS5FModel targeting model.
# Then, it calculates  the BASELINe posterior probability density functions (PDFs) for
# sequences in the updated db files; using the focused test statistic
db_baseline <- calcBaseline(db, 
                            sequenceColumn="SEQUENCE_IMGT",
                            germlineColumn="GERMLINE_IMGT_D_MASK", 
                            testStatistic="focused",
                            regionDefinition=IMGT_V_NO_CDR3,
                            targetingModel = HS5FModel,
                            nproc=1)
}
\references{
\enumerate{
  \item  Hershberg U, et al. Improved methods for detecting selection by mutation 
           analysis of Ig V region sequences. 
           Int Immunol. 2008 20(5):683-94.
  \item  Uduman M, et al. Detecting selection in immunoglobulin sequences. 
           Nucleic Acids Res. 2011 39(Web Server issue):W499-504.
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based
           on synonymous mutations from high-throughput immunoglobulin sequencing data.
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
Other selection analysis functions: \code{\link{groupBaseline}},
  \code{\link{plotBaselineDensity}},
  \code{\link{plotBaselineSummary}},
  \code{\link{summarizeBaseline}}
}

