% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sharpr2.r
\name{plot.sharpr2}
\alias{plot.sharpr2}
\title{plot.sharpr2}
\usage{
\method{plot}{sharpr2}(x, tr, unc = "CI", loess = FALSE, add = FALSE,
  xlab = "Position", ylab = "Regulatory Score", cicol = 'orange', cimcol = 'grey', 
  sreg = TRUE, ...)
}
\arguments{
\item{x}{An object returned from the sharpr2 function.}

\item{tr}{An integer indicating which tiled region to be plotted.}

\item{unc}{'MSE' or 'CI', indicating whether to plot sqrt(MSE) or 95\%CI for uncertainty. The default is 'CI'.}

\item{loess}{An indicator for whether the loess method is used for smoothing in plotting the scores from sharpr2. The standard errors are not plotted when loess is used.}

\item{add}{An indicator for whether to add the new plot to the existing one.}

\item{xlab}{The label for the x-axis. The default is 'Position'.}

\item{ylab}{The label for the y-axis. The default is 'Regulatory Score'.}

\item{cicol}{The color for CIs. The default is 'orange'.}

\item{cimcol}{The color for filling the regions within CIs. The default is 'grey'.}

\item{sreg}{An indicator for whether to highlight the identified driver element regions. The default is TRUE.}

\item{...}{Other parameters for plot.}
}
\description{
Given an object returned from the sharpr2 function, this function plots the estimated scores (with s.e. if available) for a tiled region.
}
\examples{
data(hidra_ex)
re <- sharpr2(hidra_ex[1:2000,], l_min = 150, l_max = 600, f_dna = 5, f_rna = 0, sig=FALSE)
plot(re,584)
}
\keyword{HiDRA}
\keyword{sharpr2}
