% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{SparsePLS}
\alias{SparsePLS}
\title{Sparse Partial Least Squares}
\usage{
SparsePLS(
  xdata,
  ydata,
  Lambda,
  family = "gaussian",
  ncomp = 1,
  scale = TRUE,
  keepX_previous = NULL,
  keepY = NULL,
  ...
)
}
\arguments{
\item{xdata}{matrix of predictors with observations as rows and variables as
columns.}

\item{ydata}{optional vector or matrix of outcome(s). If \code{family} is set
to \code{"binomial"} or \code{"multinomial"}, \code{ydata} can be a vector
with character/numeric values or a factor.}

\item{Lambda}{matrix of parameters controlling the number of selected
predictors at current component, as defined by \code{ncomp}.}

\item{family}{type of PLS model. If \code{family="gaussian"}, a sparse PLS
model as defined in \code{\link[sgPLS]{sPLS}} is run (for continuous
outcomes). If \code{family="binomial"}, a PLS-DA model as defined in
\code{\link[sgPLS]{sPLSda}} is run (for categorical outcomes).}

\item{ncomp}{number of components.}

\item{scale}{logical indicating if the data should be scaled (i.e.
transformed so that all variables have a standard deviation of one). Only
used if \code{family="gaussian"}.}

\item{keepX_previous}{number of selected predictors in previous components.
Only used if \code{ncomp > 1}. The argument \code{keepX} in
\code{\link[sgPLS]{sPLS}} is obtained by concatenating
\code{keepX_previous} and \code{Lambda}.}

\item{keepY}{number of selected outcome variables. This argument is defined
as in \code{\link[sgPLS]{sPLS}}. Only used if \code{family="gaussian"}.}

\item{...}{additional arguments to be passed to \code{\link[sgPLS]{sPLS}} or
\code{\link[sgPLS]{sPLSda}}.}
}
\value{
A list with: \item{selected}{matrix of binary selection status. Rows
  correspond to different model parameters. Columns correspond to
  predictors.} \item{beta_full}{array of model coefficients. Rows correspond
  to different model parameters. Columns correspond to predictors (starting
  with "X") or outcomes (starting with "Y") variables for different
  components (denoted by "PC").}
}
\description{
Runs a sparse Partial Least Squares model using implementation from
\code{\link[sgPLS]{sgPLS-package}}. This function is not using stability.
}
\examples{
## Sparse PLS

# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 100, pk = c(10, 20, 30), family = "gaussian")
x <- simul$xdata
y <- simul$ydata

# Running sPLS with 2 X-variables and 1 Y-variable
mypls <- SparsePLS(xdata = x, ydata = y, Lambda = 2, family = "gaussian", keepY = 1)


## Sparse PLS-DA

# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 200, pk = 20, family = "binomial")

# Running sPLS-DA with 2 X-variables and 1 Y-variable
mypls <- SparsePLS(xdata = simul$xdata, ydata = simul$ydata, Lambda = 2, family = "binomial")
}
\references{
\insertRef{sparsePLS}{sharp}
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{BiSelection}}

Other penalised dimensionality reduction functions: 
\code{\link{GroupPLS}()},
\code{\link{SparseGroupPLS}()},
\code{\link{SparsePCA}()}
}
\concept{penalised dimensionality reduction functions}
