% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{HugeAdjacency}
\alias{HugeAdjacency}
\title{Simulation of an undirected graph}
\usage{
HugeAdjacency(pk = 10, topology = "random", nu = 0.1, ...)
}
\arguments{
\item{pk}{number of nodes.}

\item{topology}{topology of the simulated graph. If using
\code{implementation=HugeAdjacency}, possible values are listed for the
argument \code{graph} of \code{\link[huge]{huge.generator}}. These are:
"random", "hub", "cluster", "band" and "scale-free".}

\item{nu}{expected density (number of edges over the number of node pairs) of
the graph. This argument is only used for \code{topology="random"} or
\code{topology="cluster"} (see argument \code{prob} in
\code{\link[huge]{huge.generator}}).}

\item{...}{additional arguments to be passed to
\code{\link[huge]{huge.generator}}.}
}
\value{
A symmetric adjacency matrix encoding an unweighted, undirected graph
  with no self-loops.
}
\description{
Simulates the adjacency matrix encoding an unweighted, undirected graph with
no self-loops.
}
\keyword{internal}
