% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadeFootprint.R
\name{shadeFootprint}
\alias{shadeFootprint}
\title{Shade footprint on the ground}
\usage{
shadeFootprint(build, height_field, solar_pos, b = 0.01)
}
\arguments{
\item{build}{A \code{SpatialPolygonsDataFrame} object specifying the buildings outline.}

\item{height_field}{The name of the column with building height in \code{buildings}}

\item{solar_pos}{A matrix with the solar azimuth (in degrees from North), and elevation}

\item{b}{Buffer size for shade footprints of individual segments of a given polygon; used to eliminate minor internal holes in the resulting shade polygon.}
}
\value{
A \code{SpatialPolygonsDataFrame} object representing shade footprint plus buildings outline.
}
\description{
Creates a polygonal layer of shade footprints on the ground, given sun position and extruded obstacles (usually a buildings layer).
The calculation method was inspired by Morel Weisthal's MSc thesis at Ben-Gurion University.
}
\examples{
data(build)
location = rgeos::gCentroid(build)
time = as.POSIXct("2004-12-24 13:30:00", tz = "Asia/Jerusalem")
solar_pos = maptools::solarpos(
  matrix(c(34.7767978098526, 31.9665936050395), ncol = 2),
  time
  )
footprint = shadeFootprint(build, "BLDG_HT", solar_pos)
plot(footprint, col = adjustcolor("lightgrey", alpha.f = 0.5))
plot(build, add = TRUE, col = "darkgrey")

}
\references{
Weisthal, M. (2014). Assessment of potential energy savings in Israel through climate-aware residential building design (Doctoral dissertation, Ben-Gurion University of the Negev).
\url{http://aranne5.bgu.ac.il/others/WeisthalMorel.pdf}
}

