% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_existing_balanced.R
\name{sample_existing_balanced}
\alias{sample_existing_balanced}
\title{Sample Existing Data Using Balanced Sampling}
\usage{
sample_existing_balanced(
  existing,
  nSamp,
  algorithm = "lpm2_kdtree",
  p = NULL,
  filename = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{existing}{sf 'POINT'.  Existing plot network.}

\item{nSamp}{Numeric. Number of desired samples.}

\item{algorithm}{Character. One of \code{lpm2_kdtree, lcube, lcubestratified}.}

\item{p}{Numeric. Vector with length equal to the number of cells in \code{mraster} representing
the inclusion probability for each candidate sample. Default = \code{nSamp / N}, where \code{N}
is the number of cells.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}

\item{...}{Additional arguments to pass to the selected sampling algorithm.
This is leveraged when used by \code{sample_existing()} internally}
}
\value{
An \code{sf} object that is a sub-sample of \code{existing}
}
\description{
This function samples a given set of existing data using balanced sampling techniques,
which ensures that each stratum or subgroup of data is proportionally represented in the sample.
}
\keyword{internal}
