% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_area.R
\encoding{UTF-8}
\name{sgo_area}
\alias{sgo_area}
\title{Calculate area from an ordered set of points}
\usage{
sgo_area(x, interpolate = NULL, ...)
}
\arguments{
\item{x}{A \code{sgo_points} object describing an ordered set of points.}

\item{interpolate}{Numeric variable. If not \code{NULL}, defines the maximum
distance in metres between adjacent coordinates. It is only used with
angular coordinates.}

\item{...}{Currently ignored}
}
\value{
Value of the area in squared metres round up to the first decimal.
}
\description{
Calculates the planar area for a set of points defined in the OS BNG or
ETRS89-LAEA. An accurate approximation of the geodetic area is calculated
when points are expressed in angular coordinates.
}
\details{
Calculate areas using the Gauss's area formula
(https://en.wikipedia.org/wiki/Shoelace_formula).

When using angular coordinates the function performs an approximation of the
geodetic area following the methodology discussed in Berk & Ferlan (2018)
where the area on the ellipsoid is determined by using a region-adapted
equal-area projection (Albers Equal-Area Conic) with one standard parallel.
The standard parallel and the projection origin are tied to the moment
centroid of the polygon.

Boundary segments can be divided by interpolating vertices on the projected
geodesic to reduce the error introduced by boundary simplification and to
provide an even more accurate area computation for angular coordinates.
For instance, if \code{interpolate = 500} then any segment between adjacent
coordinates whose length is greater than \code{interpolate} will be split in
parts no greater than \code{500 m} and new vertices will be added.

The area calculation in this package is best suited for features that would
be represented in a large or medium scale (like plots or council boundaries).
It will provide much less accurate results for features usually represented
at smalle scale (countries, continents, etc.).
}
\examples{
lon <- c(-6.43698696, -6.43166843, -6.42706831, -6.42102546,
-6.42248238, -6.42639092, -6.42998435, -6.43321409)
lat <- c(58.21740316, 58.21930597, 58.22014035, 58.22034112,
58.21849188, 58.21853606, 58.21824033, 58.21748949)
A <- sgo_area(sgo_points(list(lon, lat), epsg=4326))
}
\references{
Sandi Berk & Miran Ferlan, 2018. \emph{Accurate area determination in the
cadaster: case study of Slovenia}. Cartography and Geographic Information
Science, 45:1, 1-17. DOI: 10.1080/15230406.2016.1217789

Snyder, J.P. 1987. \emph{Map Projections — A Working Manual}. US Geological
Survey Professional Paper, no. 1395. Washington, DC: US Government Printing
Office. DOI: 10.3133/pp1395
}
