% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfdct.R
\name{ct_triangulate}
\alias{ct_triangulate}
\alias{ct_triangulate}
\alias{ct_triangulate.POINT}
\alias{ct_triangulate}
\alias{ct_triangulate.MULTIPOINT}
\alias{ct_triangulate}
\alias{ct_triangulate.GEOMETRYCOLLECTION}
\alias{ct_triangulate}
\alias{ct_triangulate.sfg}
\alias{ct_triangulate}
\alias{ct_triangulate.sfc}
\alias{ct_triangulate}
\alias{ct_triangulate.sf}
\title{Constrained Delaunay Triangulation}
\usage{
ct_triangulate(x, ...)

\method{ct_triangulate}{POINT}(x, trim = TRUE, ...)

\method{ct_triangulate}{MULTIPOINT}(x, trim = TRUE, ...)

\method{ct_triangulate}{GEOMETRYCOLLECTION}(x, trim = TRUE, ...)

\method{ct_triangulate}{sfg}(x, trim = TRUE, ...)

\method{ct_triangulate}{sfc}(x, ...)

\method{ct_triangulate}{sf}(x, trim = TRUE, ...)
}
\arguments{
\item{x}{simple feature geometry or data frame}

\item{...}{arguments for \code{\link[RTriangle]{triangulate}}, see details}

\item{trim}{drop triangles that fall "outside" i.e. "holes" and non-convex regions, \code{TRUE} by default}
}
\value{
simple feature column \code{\link[sf]{st_sfc}} or data frame \code{\link[sf]{st_sfc}}
}
\description{
Triangulate simple features including the input edges as constraints, rather than
being bounded to the convex hull.
}
\details{
This is not a Delaunay Triangulation by default, but is "mostly-Delaunay". Use the \code{D = TRUE} option,
passed to the underlying function in RTriangle to ensure the criterion is met, as well as edge constraints.

All POLYGON, LINESTRING, MULTIPOLYGON, and MULTILINESTRING inputs (including those in GEOMETRYCOLLECTION)
are broken down into line segments that are included in the mesh. Holes are removed
by default, but can be retained with the \code{trim} argument.

The triangles are collected as POLYGONs within a GEOMETRYCOLLECTION, and in the case of an \code{sf} object
it's returned within the original input data frame.

There's no way in this package to retain the set of shared vertices, or the segment or
the triangle indices. It is a fundamental feature of the standard, that this information is not represented.

Further arguments may be passed down to the underlying triangulation function \code{\link[RTriangle]{triangulate}}.
Note that planar coordinates are assumed, no matter what projection the input is in. There's no
sensible meaning to a value for \code{a} in units m^2 for a layer that is in longitude/latitude, for those
use "area in square degrees", the straightforward meaning in planar coordinates.
These arguments are, from the documentation of that function:
\itemize{
\item{a}{ a Maximum triangle area. If specified, triangles cannot be
larger than this area.}
\item{q}{ Minimum triangle angle in degrees.}
\item{Y}{ If \code{TRUE} prohibits the insertion of Steiner points
on the mesh boundary.}
\item{j}{ If \code{TRUE} jettisons vertices that are not part of
the final triangulation from the output.}
\item{D}{ If \code{TRUE} produce a conforming Delaunay
triangulation. This ensures that all the triangles in the mesh are
truly Delaunay, and not merely constrained Delaunay.  This option
invokes Ruppert's original algorithm, which splits every
subsegment whose diametral circle is encroached.  It usually
increases the number of vertices and triangles.}
\item{S}{ Specifies the maximum number of added Steiner points.}
\item{V}{ Verbosity level. Specify higher values  for more detailed
information about what the Triangle library is doing.}
\item{Q}{ If \code{TRUE} suppresses all explanation of what the
Triangle library is doing, unless an error occurs. }
}
}
\note{
GEOMETRYCOLLECTION as input is not yet supported.
}
\examples{
library(sf)
nc <- read_sf(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
nc_triangles <- ct_triangulate(nc[, c("NAME", "geometry")])
plot(nc[, "NAME"])
plot(nc_triangles, add = TRUE, col = NA, lty = "dotted")
idx <- c(4, 5, 6, 7, 8, 20, 21)
op <- par(mfrow = c(2, 1))
if (packageVersion("sf") <= '0.2.8'){
nc <- st_transform(nc, "+proj=eqc +ellps=WGS84")
}

plot(st_triangulate(nc[idx, c("NAME", "geometry")]), col = "grey")
plot(ct_triangulate(nc[idx, c("NAME", "geometry")]))

}
