% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{st_sample}
\alias{st_sample}
\title{sample points on or in (sets of) spatial features}
\usage{
st_sample(x, size, ..., type = "random", exact = TRUE)
}
\arguments{
\item{x}{object of class \code{sf} or \code{sfc}}

\item{size}{sample size(s) requested; either total size, or a numeric vector with sample sizes for each feature geometry. When sampling polygons, the returned sampling size may differ from the requested size, as the bounding box is sampled, and sampled points intersecting the polygon are returned.}

\item{...}{ignored, or passed on to \link[base]{sample} for \code{multipoint} sampling}

\item{type}{character; indicates the spatial sampling type; one of \code{regular}, \code{hexagonal} and \code{regular}.}

\item{exact}{logical; should the length of output be exactly
the same as specified by \code{size}? \code{TRUE} by default. Only applies to polygons, and
when \code{type = "random"}.}
}
\value{
an \code{sfc} object containing the sampled \code{POINT} geometries
}
\description{
Sample points on or in (sets of) spatial features.
By default, returns a pre-specified number of points that is equal to
\code{size} (if \code{type = "random"}) or an approximation of
\code{size} (for other sampling types).
}
\details{
The function is vectorised: it samples \code{size} points across all geometries in
the object if \code{size} is a single number, or the specified number of points
in each feature if \code{size} is a vector of integers equal in length to the geometry
of \code{x}.

if \code{x} has dimension 2 (polygons) and geographical coordinates (long/lat), uniform random sampling on the sphere is applied, see e.g. \url{http://mathworld.wolfram.com/SpherePointPicking.html}

For \code{regular} or \code{hexagonal} sampling of polygons, the resulting size is only an approximation.

As parameter called \code{offset} can be passed to control ("fix") regular or hexagonal sampling: for polygons a length 2 numeric vector (by default: a random point from \code{st_bbox(x)}); for lines use a number like \code{runif(1)}.
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
p1 = st_sample(nc[1:3, ], 6)
p2 = st_sample(nc[1:3, ], 1:3)
plot(st_geometry(nc)[1:3])
plot(p1, add = TRUE)
plot(p2, add = TRUE, pch = 2)
x = st_sfc(st_polygon(list(rbind(c(0,0),c(90,0),c(90,90),c(0,90),c(0,0)))), crs = st_crs(4326))
plot(x, axes = TRUE, graticule = TRUE)
if (sf_extSoftVersion()["proj.4"] >= "4.9.0")
  plot(p <- st_sample(x, 1000), add = TRUE)
x2 = st_transform(st_segmentize(x, 1e4), st_crs("+proj=ortho +lat_0=30 +lon_0=45"))
g = st_transform(st_graticule(), st_crs("+proj=ortho +lat_0=30 +lon_0=45"))
plot(x2, graticule = g)
if (sf_extSoftVersion()["proj.4"] >= "4.9.0") {
  p2 = st_transform(p, st_crs("+proj=ortho +lat_0=30 +lon_0=45"))
  plot(p2, add = TRUE)
}
x = st_sfc(st_polygon(list(rbind(c(0,0),c(90,0),c(90,10),c(0,90),c(0,0))))) # NOT long/lat:
plot(x)
p_exact = st_sample(x, 1000, exact = TRUE)
p_not_exact = st_sample(x, 1000, exact = FALSE)
length(p_exact); length(p_not_exact)
plot(st_sample(x, 1000), add = TRUE)
x = st_sfc(st_polygon(list(rbind(c(-180,-90),c(180,-90),c(180,90),c(-180,90),c(-180,-90)))),
 crs=st_crs(4326))
if (sf_extSoftVersion()["proj.4"] >= "4.9.0") {
  p = st_sample(x, 1000)
  st_sample(p, 3)
}
# hexagonal:
sfc = st_sfc(st_polygon(list(rbind(c(0,0), c(1,0), c(1,1), c(0,0)))))
plot(sfc)
h = st_sample(sfc, 100, type = "hexagonal")
h1 = st_sample(sfc, 100, type = "hexagonal")
plot(h, add = TRUE)
plot(h1, col = 'red', add = TRUE)
c(length(h), length(h1)) # approximate!
pt = st_multipoint(matrix(1:20,,2))
ls = st_sfc(st_linestring(rbind(c(0,0),c(0,1))),
 st_linestring(rbind(c(0,0),c(.1,0))),
 st_linestring(rbind(c(0,1),c(.1,1))),
 st_linestring(rbind(c(2,2),c(2,2.00001))))
st_sample(ls, 80)
plot(st_sample(ls, 80))
}
