% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp.R
\name{as_Spatial}
\alias{as_Spatial}
\title{Methods to coerce simple feature objects to \code{Spatial*} objects}
\usage{
as_Spatial(from, cast = TRUE, IDs = paste0("ID", 1:length(from)))
}
\arguments{
\item{from}{object of class \code{sfc_POINT}, \code{sfc_MULTIPOINT}, \code{sfc_LINESTRING}, \code{sfc_MULTILINESTRING}, \code{sfc_POLYGON}, or \code{sfc_MULTIPOLYGON}.}

\item{cast}{logical; if \code{TRUE}, \link{st_cast} \code{from} before converting, so that e.g. \code{GEOMETRY} objects with a mix of \code{POLYGON} and \code{MULTIPOLYGON} are cast to \code{MULTIPOLYGON}.}

\item{IDs}{character vector with IDs for the \code{Spatial*} geometries}
}
\value{
geometry-only object deriving from \code{Spatial}, of the appropriate class
}
\description{
Methods to coerce simple feature objects to \code{Spatial*} objects
}
