% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geos_binary_ops}
\alias{geos_binary_ops}
\alias{st_intersection}
\alias{geos_binary_ops}
\alias{st_difference}
\alias{geos_binary_ops}
\alias{st_sym_difference}
\title{Geometric binary operations on pairs of simple feature geometry sets}
\usage{
st_intersection(x, y)

st_difference(x, y)

st_sym_difference(x, y)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{y}{object of class \code{sf}, \code{sfc} or \code{sfg}}
}
\value{
an object of the same class as that of the first argument (\code{x}) with the non-empty geometries resulting from applying the operation to all geometry pairs in \code{x} and \code{y}. In case \code{x} is of class \code{sf}, the matching attributes of the original object(s) are added. The \code{sfc} geometry list-column returned carries an attribute \code{idx}, which is an \code{n x 2} matrix with every row the index of the corresponding entries of \code{x} and \code{y}, respectively.
}
\description{
Geometric binary operations on pairs of simple feature geometry sets
}
\details{
a spatial index is built on argument \code{x}; see http://r-spatial.org/r/2017/06/22/spatial-index.html
}
\examples{
# a helper function that erases all of y from x:
st_erase = function(x, y) st_difference(x, st_union(st_combine(y)))
}
\seealso{
\link{st_union}
}
