% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-files.R
\name{Files}
\alias{Files}
\title{R6 Class representing files endpoints.}
\description{
R6 Class representing Files resource.
}
\examples{

## ------------------------------------------------
## Method `Files$query`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Query files in a project
 files_object$query(project = project)
}


## ------------------------------------------------
## Method `Files$get`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Get file using id
 files_object$get(id = id)
}


## ------------------------------------------------
## Method `Files$delete`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Delete a file
 files_object$delete(file = file)
}


## ------------------------------------------------
## Method `Files$copy`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Copy files to a project
 files_object$copy(
               file = file,
               destination_project = project
              )
}


## ------------------------------------------------
## Method `Files$create_folder`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Create folder in a project
 files_object$create_folder(
                name = name,
                project = project
               )
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Files}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Files-new}{\code{Files$new()}}
\item \href{#method-Files-query}{\code{Files$query()}}
\item \href{#method-Files-get}{\code{Files$get()}}
\item \href{#method-Files-delete}{\code{Files$delete()}}
\item \href{#method-Files-copy}{\code{Files$copy()}}
\item \href{#method-Files-create_folder}{\code{Files$create_folder()}}
\item \href{#method-Files-clone}{\code{Files$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-new"></a>}}
\if{latex}{\out{\hypertarget{method-Files-new}{}}}
\subsection{Method \code{new()}}{
Create new Files resource object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-query"></a>}}
\if{latex}{\out{\hypertarget{method-Files-query}{}}}
\subsection{Method \code{query()}}{
This call returns a list of files and subdirectories in a
specified project or directory within a project, with specified
properties that you can access. The project or directory whose contents
you want to list is specified as a query parameter in the call. Further
properties to filter by can also be specified as query parameters.
\cr \cr
Note that this call lists both files and subdirectories in the
specified project or directory within a project, but not the contents
of the subdirectories. \cr
To list the contents of a subdirectory, make a new call
and specify the subdirectory ID as the \code{parent} parameter. \cr
More information you can find in our
\href{https://docs.sevenbridges.com/reference/list-files-primary-method}{API documentation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$query(
  project = NULL,
  parent = NULL,
  name = NULL,
  metadata = NULL,
  origin = NULL,
  tag = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project}}{Project identifier (ID) as string or a Project object.
Project should not be used together with parent.
If parent is used, the call will list the content of the specified
folder, within the project to which the folder belongs.
If project is used, the call will list the content at the root of
the project's files.}

\item{\code{parent}}{The parent folder identifier as string or a File object
which must be of type \code{FOLDER}.
Should not be used together with project.
If parent is used, the call will list the content of the specified
folder, within the project to which the folder belongs.
If project is used, the call will list the content at the root of
the project's files.}

\item{\code{name}}{Name of the file. List files with this name. Note that the
name must be an exact complete string for the results to match.
Multiple names can be represented as a vector.}

\item{\code{metadata}}{List file with this metadata field values. List only
files that have the specified value in metadata field. Different
metadata fields are represented as a named list. You can also define
multiple instances of the same metadata field.}

\item{\code{origin}}{Task object. List only files produced by task.}

\item{\code{tag}}{List files containing this tag. Note that the tag must be an
exact complete string for the results to match. Multiple tags can be
represented by vector of values.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{File}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Query files in a project
 files_object$query(project = project)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-get"></a>}}
\if{latex}{\out{\hypertarget{method-Files-get}{}}}
\subsection{Method \code{get()}}{
This call returns a single File object with its details.
The call returns the file's name, its tags, and all of its metadata.
Files are specified by their IDs, which you can obtain by making
the API call to list all files in a project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The file ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{File}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Get file using id
 files_object$get(id = id)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Files-delete}{}}}
\subsection{Method \code{delete()}}{
This call removes a file from the Seven Bridges Platform.
Files are specified by their IDs, which you can obtain by using
\code{Files$query()} to list files or by getting a single file
using \code{Files$get()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$delete(file, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{\code{\link{File}} object or file ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Delete a file
 files_object$delete(file = file)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-copy"></a>}}
\if{latex}{\out{\hypertarget{method-Files-copy}{}}}
\subsection{Method \code{copy()}}{
Copy file/files to the specified project. This call allows
you to copy files between projects. Unlike the call to copy a file
between projects, this call lets you batch the copy operation and copy
a list of files at a time. \cr
More information you may find
\href{https://docs.sevenbridges.com/reference/copy-files-between-projects}{here}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$copy(files, destination_project)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{files}}{The list of files' IDs or list of File object to copy.}

\item{\code{destination_project}}{Project object or project ID.
where you want to copy files into.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Copy files to a project
 files_object$copy(
               file = file,
               destination_project = project
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-create_folder"></a>}}
\if{latex}{\out{\hypertarget{method-Files-create_folder}{}}}
\subsection{Method \code{create_folder()}}{
A method for creating a new folder. It allows you to create
a new folder on the Platform within the root folder of a specified
project or the provided parent folder. Remember that you should provide
either the destination project (as the \code{project} parameter) or the
destination folder (as the \code{parent} parameter), not both. \cr
More information you may find
\href{https://docs.sevenbridges.com/reference/create-a-folder}{here}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$create_folder(name, parent = NULL, project = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the folder you are about to create.}

\item{\code{parent}}{The ID of the parent destination folder or a File
object which must be of type \code{FOLDER}.}

\item{\code{project}}{The ID of the destination project, or a Project object.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Create folder in a project
 files_object$create_folder(
                name = name,
                project = project
               )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Files-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
