% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testFinite}
\alias{testFinite}
\alias{checkFinite}
\alias{assertFinite}
\title{assert/check/test/Finite}
\usage{
testFinite(object, errormsg = "This is not finite")

checkFinite(object, errormsg = "This is not finite")

assertFinite(object, errormsg = "This is not finite")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is finite.
}
\examples{
testFinite(Interval$new(1, 10, class = "integer"))
testFinite(Interval$new(1, 10, class = "numeric"))
}
