% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mseir_model.R
\name{mseir_model}
\alias{mseir_model}
\title{MSEIR model}
\usage{
mseir_model(a, gamma, lambda, sigma, nu)
}
\arguments{
\item{a}{age sequence}

\item{gamma}{time in maternal class.}

\item{lambda}{time in susceptible class.}

\item{sigma}{time in latent class.}

\item{nu}{time in infected class.}
}
\value{
list of class mseir_model with the following parameters
  \item{parameters}{list of parameters used for fitting the model}
  \item{output}{matrix of proportion for each compartment over time}
}
\description{
Refers to section 3.4.
}
\examples{
model <- mseir_model(
  a=seq(from=1,to=20,length=500), # age range from 0 -> 20 yo
  gamma=1/0.5, # 6 months in the maternal antibodies
  lambda=0.2,  # 5 years in the susceptible class
  sigma=26.07, # 14 days in the latent class
  nu=36.5      # 10 days in the infected class
)
model

}
