% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_tsne.R
\name{register_tsne}
\alias{register_tsne}
\alias{tsne}
\alias{tSNE}
\title{Register Seriation Based on 1D t-SNE}
\usage{
register_tsne()
}
\value{
Nothing.
}
\description{
Use t-distributed stochastic neighbor embedding (t-SNE) for \code{\link[=seriate]{seriate()}}.
}
\details{
Registers the method \code{"tsne"} for \code{\link[=seriate]{seriate()}}. This method applies
1D t-SNE to data represented by a distance matrix and extracts the order
from the 1D embedding. To speed up the process, an initial embedding is
created using multi-dimensional scaling (MDS) which is improved by t-SNE.

The \code{control} parameter \code{mds} controls if MDS is used to create an
initial embedding. See \code{\link[Rtsne:Rtsne]{Rtsne::Rtsne()}} to learn about the other
available \code{control} parameters.

\bold{Note:} Package \pkg{Rtsne} needs to be installed.
}
\examples{

\dontrun{
register_tsne()
get_seriation_method("dist", "tsne")

d <- dist(random.robinson(50, pre=TRUE, noise=.1))

o <- seriate(d, method = "tsne")
pimage(d, o)
}

}
\references{
van der Maaten, L.J.P. & Hinton, G.E., 2008. Visualizing
High-Dimensional Data Using t-SNE. Journal of Machine Learning Research, 9,
pp.2579-2605.
}
\seealso{
\code{\link[Rtsne:Rtsne]{Rtsne::Rtsne()}} in \pkg{Rtsne}.

Other seriation: 
\code{\link{register_DendSer}()},
\code{\link{register_GA}()},
\code{\link{register_optics}()},
\code{\link{register_umap}()},
\code{\link{registry_seriate}},
\code{\link{seriate}()}
}
\concept{seriation}
\keyword{cluster}
\keyword{optimize}
