% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuplicateCheck.R
\name{DuplicateCheck}
\alias{DuplicateCheck}
\title{Check Data for Duplicates.}
\usage{
DuplicateCheck(GenoM = NULL, FortPARAM, quiet)
}
\arguments{
\item{GenoM}{matrix with genotype data, size nInd x nSnp.}

\item{FortPARAM}{list with Fortran-ready parameter values, as generated by
\code{\link{MkFortParams}}.}

\item{quiet}{suppress messages.}
}
\value{
A list with one or more of the following elements:
\item{DupGenoID}{Dataframe, row numbers of duplicated IDs in genotype data.
  Please do remove or relabel these to avoid downstream confusion.}
\item{DupGenotype}{Dataframe, duplicated genotypes (with or without identical
  IDs). The specified number of maximum mismatches is allowed, and this
  dataframe may include pairs of closely related individuals. Mismatch =
  number of SNPs at which genotypes differ, LLR = likelihood ratio between
  'self' and most likely non-self.}
}
\description{
Check the genotype and life history data for duplicate IDs (not
  permitted) and duplicated genotypes (not advised), and count how many
  individuals in the genotype data are not included in the life history data
  (permitted). The order of IDs in the genotype and life history data is not
  required to be identical.
}
\seealso{
\code{\link{CheckLH}}, which performs the check for duplicated IDs
  in the life history data, as well as for IDs (in genotype data) for which
  no life history data is provided.
}
\keyword{internal}
