% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theo.R
\name{seqgen_diff}
\alias{seqgen_diff}
\title{Theoretical sequence simulation for differential expression analysis.}
\usage{
seqgen_diff(designmat, coefmat, dispvec, design_sv = NULL,
  coef_sv = NULL)
}
\arguments{
\item{designmat}{A numeric design matrix. The rows index the samples
and the columns index the variables.}

\item{coefmat}{A numeric matrix of coefficients. The rows index the
genes and the columns index the variables.}

\item{dispvec}{A vector of negative binomial dispersion parameters.
Element i is the dispersion for gene i.}

\item{design_sv}{A numeric design matrix for the surrogate variables.
The rows index the samples and the columns index the surrogate
variables.}

\item{coef_sv}{A numeric matrix of coefficients for the surrogate
variables. The rows index the genes and the columns index the
variables.}
}
\value{
A list object with some or all of the following elements:
\describe{
 \item{\code{mat}}{A matrix of RNA-seq counts. The rows index the genes and
     the columns index the samples.}
 \item{\code{designmat}}{The user-provided \code{designmat}.}
 \item{\code{coefmat}}{The user-provided \code{coefmat}.}
 \item{\code{sv}}{The user-provided \code{design_sv}.}
 \item{\code{coef_sv}}{The user-provided \code{coef_sv}.}
}
}
\description{
Generate a matrix of RNA-seq counts from a theoretical negative-binomial
model.
}
\details{
You should be using \code{\link{thin_diff}} instead of this. If you must
simulate from the theoretical model, I would recommend trying out
the powsimR package (\url{https://github.com/bvieth/powsimR}) from
Vieth et al. (2017).
}
\references{
\itemize{
  \item{Vieth, Beate, Christoph Ziegenhain, Swati Parekh, Wolfgang Enard, and Ines Hellmann. "powsimR: power analysis for bulk and single cell RNA-seq experiments." Bioinformatics 33, no. 21 (2017): 3486-3488.}
}
}
\author{
David Gerard
}
